//+------------------------------------------------------------------+
//|                                                        |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2005, FX Sniper "
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_chart_window

#property  indicator_buffers 3
#property indicator_color1 Yellow      
#property indicator_color2 MediumBlue
#property indicator_color3 Black

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

extern int Rperiod = 48;
extern int Draw4HowLong = 5000;

//----- variables
int    c;
int    i;
int    length;
double lengthvar;
int    loopbegin;
int    pos;
int    width;


// arrays 
double sum[];
double tmp ;
double wt[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   //2 additional buffers are used for counting.
   IndicatorBuffers(5);

   SetIndexBuffer(2,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(0,ExtMapBuffer3);
   SetIndexBuffer(3,sum);
   SetIndexBuffer(4,wt);
    
   SetIndexStyle(2, DRAW_LINE, STYLE_SOLID, 3);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 3);
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 3);

   return(0);
  }

int start()

  {   
      length = Rperiod;
      loopbegin = Draw4HowLong - length - 1;
 
      for(pos = loopbegin; pos >= 0; pos--)
      { 
         sum[1] = 0;
         for(i = length; i >= 1  ; i--)
         {
         lengthvar = length + 1;
         lengthvar /= 3;
         tmp = 0;
         tmp = ( i - lengthvar)*Close[length-i+pos];
         sum[1]+=tmp;
         }
         
         wt[pos] = sum[1]*6/(length*(length+1));
         
//========== COLOR CODING ===========================================               
        
      // 1 Yellow      
      // 2 Green
      // 3 Red

       ExtMapBuffer3[pos] = wt[pos]; //red 
       ExtMapBuffer2[pos] = wt[pos]; //green
       ExtMapBuffer1[pos] = wt[pos]; //yellow
       
        if (wt[pos+1] > wt[pos])
        {
        ExtMapBuffer2[pos+1] = EMPTY_VALUE;
        }
       else if (wt[pos+1] < wt[pos]) 
        {
        ExtMapBuffer1[pos+1] = EMPTY_VALUE; //-1 red/greem tight
        }
         else 
         {
         ExtMapBuffer1[pos+1]=CLR_NONE;//EMPTY_VALUE;
         ExtMapBuffer2[pos+1]=CLR_NONE;//EMPTY_VALUE;
         }
        
      }
    
      return(0);
  }
//+------------------------------------------------------------------+


/*
int start()
  {
   double   cMAfst=0, pMAfst=0;
   double   cMAslo=0, pMAslo=0;
   double    MA100=0;
   double    p=Point();
      
   bool     found=false;
   bool    rising=false;
   bool   falling=false;
   bool    bought=false;
   bool      sold=false;
   bool oldenough=false;
   
   int      cnt=0;
   int      err=0;
   

   // Error checking
   if(Bars<100)                        {Print("Bars less than 100"); return(0);}
   if(AccountFreeMargin()<(1000*Lots)) {Print("We have no money");   return(0);}

   // get all the moving averages at once
   cMAfst=iMA(Symbol(),0,5  ,0,MODE_LWMA,PRICE_CLOSE, 1);
   pMAfst=iMA(Symbol(),0,5  ,0,MODE_LWMA,PRICE_CLOSE, 2);
   cMAslo=iMA(Symbol(),0,25 ,0,MODE_LWMA,PRICE_CLOSE, 1);
   pMAslo=iMA(Symbol(),0,25 ,0,MODE_LWMA,PRICE_CLOSE, 2);
   MA100= iMA(Symbol(),0,100,0,MODE_LWMA,PRICE_CLOSE, 1);

   // determine if FST line is rising or falling around SLO line
   if (pMAfst<=pMAslo && cMAfst>=cMAslo) {rising=true;  falling=false;}
   if (pMAfst>=pMAslo && cMAfst<=cMAslo) {rising=false; falling=true;}

   // Does the Symbol() have an open order
   for(cnt=0;cnt<OrdersTotal();cnt++)
     {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderSymbol()==Symbol())
        {found=true; break;}
         else
        {found=false;}        
     }
   
   //Leave if there is no open order 
   if (found==false) {Print(Symbol()," Order not found"); return(0);}
   
   // Leave if order was less than 4 periods ago
   //if ((Time[0]-OrderOpenTime())<300) {Print(Symbol()," not old enough ", Time[0]-OrderOpenTime()); return(0);}
   if ((Time[0]-OrderOpenTime())<300) {return(0);}

   if (OrderType()==0) {bought=true;  sold=false;}
   if (OrderType()==1) {bought=false; sold=true;}

   // wrong direction, just print report
   if (rising && bought) {Print("Cross, but already Buy "); return(0);}
   if (falling && sold)  {Print("Cross, but already Sell"); return(0);}
     
   if (rising && sold)       //exist sell
     {
      Print(Symbol()," CLOSE sell BUY buy");
      OrderClose(OrderTicket(),Lots,Ask,0,Red);
      err=GetLastError();
      if(err==0)
        {
         Print("BUY  Order started  ",Ask);
         OrderSend(Symbol(),OP_BUY,Lots,Ask,3,Ask-(p*50),0,"BC Buy ",16123,0,White);
         if(GetLastError()==0)Comment("BC_BUY  Order opened : ",Ask);
        }
         else
        {
         Print(Symbol(),"BUY Error ",err);
        }
     }
   if (falling && bought)  // exist buy
     {
      Print(Symbol(),Time[0],OrderOpenTime(),"CLOSE buy BUY sell");
      OrderClose(OrderTicket(),Lots,Bid,0,White);
      err=GetLastError();
      if(err==0)
        {
         Print("SELL Order started  ",Bid);
         OrderSend(Symbol(),OP_SELL,Lots,Bid,3,Bid+(p*50),0,"BC Sell",16321,0,Red);
         if(GetLastError()==0)Comment("BC_SELL Order opened : ",Bid );
        }
         else
        {
         Print(Symbol(),"SELL Error ",err);
        }
     }


   //Print(Symbol()," Tick");
   return(0);
   
*/


